package com.hero.objects.skills;

import org.jdom.Element;

import com.hero.ui.dialog.CustomSkillDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CustomSkill extends Skill {

	private static String xmlID = "CUSTOMSKILL";

	private int roll;

	public CustomSkill(Element template) {
		super(template, CustomSkill.xmlID);
		minimumLevel = -999;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		CustomSkillDialog dialog = new CustomSkillDialog(this, isNew, isPower);
		return dialog;
	}

	@Override
	public String getRoll() {
		String ret = getRollValue() + "-";
		if (roll == 0) {
			return "";
		} else {
			return ret;
		}
	}

	@Override
	public int getRollValue() {
		return roll;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setAttribute("ROLL", "" + roll);
		return root;
	}

	@Override
	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		String check = XMLUtility.getValue(root, "ROLL");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
				roll = 0;
			}
		} else {
			roll = 0;
		}
	}

	public void setRoll(int val) {
		roll = val;
	}
}